//
//  InferUnreferencedPoints.h
//  tests
//
//  Created by Simon Cozens on 16/04/2019.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <GSFontTools/GXTupleVariation.h>

@class FTPointArray;
@class Glyph_g_l_y_f;
@class GSIntArray;
@class TTFont;

NS_ASSUME_NONNULL_BEGIN

@interface GXTupleVariation (InferUnreferencedPoints)

+ (NSPoint)inferDeltaForPoint:(NSPoint)target prevPoint:(NSPoint)pp prevDelta:(NSPoint)pd nextPoint:(NSPoint)np nextDelta:(NSPoint)nd;
+ (NSPoint)inferDeltaForPointAtIndex:(NSInteger)idx points:(FTPointArray *)points deltas:(FTPointArray *)deltas endPtsOfContours:(GSIntArray *)endPtsOfContours;
+ (void)inferAllDeltas:(FTPointArray *)deltas endPtsOfContours:(GSIntArray *)endPtsOfContours points:(FTPointArray *)points;
+ (bool)canInferIndex:(NSInteger)idx points:(FTPointArray *)points deltas:(FTPointArray *)deltas endPtsOfContours:(GSIntArray *)endPtsOfContours withTolerance:(CGFloat)tolerance;
+ (bool)canInferBetween:(NSInteger)i and:(NSInteger)j points:(FTPointArray *)points deltas:(FTPointArray *)deltas withTolerance:(CGFloat)tolerance;
+ (FTPointArray *)optimizeDeltas:(FTPointArray *)deltas points:(FTPointArray *)points ends:(GSIntArray *)ends withTolerance:(CGFloat)tolerance;

// Main entry point for writer
- (GXTupleVariation *)optimizeWithTolerance:(CGFloat)tolerance glyph:(Glyph_g_l_y_f *)glyph font:(TTFont *)font;

@end

NS_ASSUME_NONNULL_END
